<?php if ( ! defined( 'ABSPATH' ) ) { die; } // Cannot access pages directly.
// ===============================================================================================
// -----------------------------------------------------------------------------------------------
// FRAMEWORK SETTINGS
// -----------------------------------------------------------------------------------------------
// ===============================================================================================
class CS_WHATSAPP_CHAT_SETTINGS{
	
	public function set_options(){
		// ===============================================================================================
		// -----------------------------------------------------------------------------------------------
		// FRAMEWORK OPTIONS
		// -----------------------------------------------------------------------------------------------
		// ===============================================================================================
		$options    = array();
		$options['general']    = array(
			'name'        => 'general',
			'title'       => __('General Settings','uwac'),
			'icon'        => 'cli cli-settings',
			
			// begin: fields
			'fields'      => array(
				array(
					'type'    => 'heading',
					'content' => __('Ultimate WhatsApp Chat','uwac'),
				),
				array(
					'type'    => 'content',
					'content' => __('With Ultimate WhatsApp Chat you can add a chat widget to all the pages of your website, based on different user accounts and pages. You can also choose the theme you want and customize it completely!','uwac'),
				),

				array(
					'id'         => 'plugin_status',
					'type'       => 'button_set',
					'title'      => __('I Want To','uwac'),
					'options'    => array(
						'enabled'  	=> __('Enable Ultimate WhatsApp Chat','uwac'),
						'disabled'  => __('Disable for a while','uwac'),
					),
					'default'    => 'enabled',
				),
				array(
					'id'				=> 'general_settings',
					'type'				=> 'accordion',
					'accordion_title'	=> 'Accordion Title',
					'accordion_content'	=> array(
						array(
							'id'        	=> 'general_messages',
							'title'     	=> __('Messages','uwac'),
							'description'	=> __('Set the default user account messages','uwac'),
							'fields'   	 	=> array(
								array(
									'id'            => 'default_welcome_text',
									'type'          => 'text',
									'title'         => __('Predefined Chat Initial Message','uwac'),
									'subtitle'		=> __('It will be displayed as the first message that the user will send to an agent','uwac'),
									'desc'			=> __('Available tags: <code>%agent_name%</code>, <code>%page_title%</code>, <code>%page_url%</code>, <code>%product_name%</code>'),
									'default'		=> __('Hello %agent_name% I need some help here @ %page_title%','uwac'),
								),
								array(
									'id'            => 'default_button_text',
									'type'          => 'text',
									'title'         => __('Button Message Text','uwac'),
									'subtitle'		=> __('Shown on the user account buttons called by shortcode','uwac'),
									'default'		=> __('Need help? Chat with me on WhatsApp ;)','uwac'),
								),
								array(
									'id'            => 'default_online_text',
									'type'          => 'text',
									'title'         => __('Online Status Text','uwac'),
									'subtitle'		=> __('Shown on workdays, when the account is online.','uwac'),
									'default'		=> __('Can I help you?','uwac'),
								),
								array(
									'id'            => 'default_unavailable_text',
									'type'          => 'text',
									'title'         => __('Workdays Unavailable Status Text','uwac'),
									'subtitle'		=> __('Shown on workdays, when it is not online yet.','uwac'),
									'desc'			=> __('Available tags: <code>%status%</code>, <code>%online_from%</code>, <code>%online_to%</code>'),
									'default'		=> __('I will be available in a few minutes','uwac'),
								),
								array(
									'id'            => 'default_offline_text',
									'type'          => 'text',
									'title'         => __('Non-working Days Status Text','uwac'),
									'subtitle'		=> __('Shown on non-working days. The user account is offline.','uwac'),
									'desc'			=> __('Available tags: <code>%status%</code>, <code>%online_from%</code>, <code>%online_to%</code>'),
									'default'		=> __('Online from %online_from% to %online_to% GMT+4','uwac'),
								),
							),
						),
						array(
							'id'			=> 'plugin_access',
							'title'			=> __('Plugin Admin Panel Access Rights','uwac'),
							'description'	=> __('Controls user access to the plugin settings panel','uwac'),
							'fields'		=> array(
								array(
									'id'         	=> 'accessrights',
									'type'       	=> 'button_set',
									'title'      	=> __('Allow access to','uwac'),
									'options'    	=> array(
										'all'			=> 'All Users',
										'superadmin'	=> 'Super Admin',
										// 'user'  		=> 'Specific User',
									),
									'default'    	=> 'all',
									// 'desc'			=> __('For security reasons the current user will always be allowed to access the plugin settings panel.','uwac'),
								),
								array(
									'dependency'		=> array('accessrights','==','user'),
									'id'            	=> 'accessrights_user',
									'type'          	=> 'text',
									'title'         	=> __('Allow Access by User','uwac'),
									'subtitle'      	=> __('Allow access only to this specific user','uwac'),
									'desc'          	=> __('Enter the username or user ID','uwac'),
									'default'       	=> '',
									'wrap_class'		=> 'cssf-field-subfield',
								),
							),
						),
					),
				),
			),
		);
		
		/* ===============================================================================================
            USER ACCOUNTS
        =============================================================================================== */
		$options['accounts']	= array(
			'name'        => 'accounts',
			'title'       => __('User Accounts','uwac'),
			'icon'        => 'cli cli-user',
			
			'fields'      => array(
				array(
					'type'    => 'heading',
					'content' => __('User Accounts','uwac'),
				),
				array(
					'type'    => 'content',
					'content' => __('Create or modify any user accounts or support teams that you want. Use a personal WhatsApp number or a Group url to link.','uwac'),
				),
				array(
					'id'            => 'user_account_idcounter',
					'type'          => 'text',
					'title'         => __('ID COUNTER','uwac'),
					'default'		=> '0',
					'attributes'	=> array(
						'readonly'	=> 'readonly',
						'hidden'	=> 'hidden',
					),
					'wrap_class'	=> 'hidden',
				),
				
				array(
					'id'              => 'user_accounts',
					'type'            => 'group',
					// 'title'           => 'Group Field',
					// 'desc'            => 'Accordion title using the ID of the field.',
					'button_title'    		=> __('Add a new user account','uwac'),
					'accordion_title_new' 	=> __('New User Account','uwac'),
					'accordion_title'		=> false,
					// 'accordion_title_field'	=> 'user_account_name',
					'accordion_title_format'=> array(
						'format'	=> __('User Account: %user_name% (ID: %user_id%)','uwac'),
						'fields'	=> array(
							'%user_name%'	=> 'user_account_name',
							'%user_id%'		=> 'user_account_id',
						),
					),
					'fields'          		=> array(
						array(
							'id'            => 'user_account_avatar',
							'type'          => 'image',
							'title'         => __('User Account Avatar','uwac'),
							'subtitle'      => __('Upload an image to use as the user\'s avatar','uwac'),
							'settings'      => array(
								'button_title' 	=> __('Choose Avatar','uwac'),
								'frame_title'  	=> __('Choose an avatar','uwac'),
								'insert_title' 	=> __('Use this image as avatar','uwac'),
								'preview_size'  => 'thumbnail',
							),
						),
						array(
							'id'            => 'user_account_name',
							'type'          => 'text',
							'title'         => __('User Name','uwac'),
							'subtitle'		=> __('Name this account with the user\'s name','uwac'),
							'label_type'	=> 'top',
							'columns' 		=> '6',
						),
						array(
							'id'            => 'user_account_id',
							'type'          => 'text',
							'title'         => __('User Account ID','uwac'),
							'subtitle'		=> __('Account ID to use on shortcodes','uwac'),
							'desc'			=> __('Shortcode Example: [uwac_agent id="user_account_id"]','uwac'),
							'label_type'	=> 'top',
							'columns' 		=> '6',
							// 'attributes'	=> array(
							// 	'readonly'	=> 'readonly',
							// ),
						),
						array(
							'id'            => 'user_account_number',
							'type'          => 'text',
							'title'         => __('Account Phone Number or Group Chat URL','uwac'),
							'desc'			=> sprintf(__('For a detailed explanation on international numbers, read this <a href="%s" target="_blank">article</a>.', 'uwac'), 'https://faq.whatsapp.com/en/general/21016748'),
							'help'			=> __('Insert the full phone number in international format. Omit any zeroes, brackets or dashes when adding the phone number in international format. You can also add a group share url link.','uwac'),
							'label_type'	=> 'top',
							'columns' 		=> '6',
						),
						array(
							'id'            => 'user_account_label',
							'type'          => 'text',
							'title'         => __('Account Name','uwac'),
							'desc'			=> __('Ex: Customer Executive','uwac'),
							'label_type'	=> 'top',
							'columns' 		=> '6',
						),

						array(
							'id'				=> 'useraccount_sections',
							'type'				=> 'accordion',
							'accordion_title'	=> 'Accordion Title',
							'accordion_content'	=> array(
								array(
									'id'        	=> 'ua_messages',
									'title'     	=> __('Messages','uwac'),
									'description'	=> __('Set the user account default messages','uwac'),
									'fields'   	 	=> array(
										array(
											'id'            => 'user_account_welcome_text',
											'type'          => 'text',
											'title'         => __('Predefined Chat Initial Message','uwac'),
											'subtitle'		=> __('It will be displayed as the first message that the user will send to this agent','uwac'),
											'desc'			=> __('Available tags: <code>%agent_name%</code>, <code>%page_title%</code>, <code>%page_url%</code>, <code>%product_name%</code>'),
											'default'		=> __('Hello %agent_name% I need some help here @ %page_title%','uwac'),
										),
										array(
											'id'            => 'user_account_button_text',
											'type'          => 'text',
											'title'         => __('Button Message Text','uwac'),
											'subtitle'		=> __('Shown on the user account buttons called by shortcode','uwac'),
											'default'		=> __('Need help? Chat with me on WhatsApp ;)','uwac'),
										),
										array(
											'id'            => 'user_account_online_text',
											'type'          => 'text',
											'title'         => __('Online Status Text','uwac'),
											'subtitle'		=> __('Shown on workdays, when the account is online.','uwac'),
										),
										array(
											'id'            => 'user_account_unavailable_text',
											'type'          => 'text',
											'title'         => __('Workdays Unavailable Status Text','uwac'),
											'subtitle'		=> __('Shown on workdays, when it is not online yet.','uwac'),
											'desc'			=> __('Available tags: <code>%status%</code>, <code>%online_from%</code>, <code>%online_to%</code>'),
											'default'		=> __('I will be available in a few minutes','uwac'),
										),
										array(
											'id'            => 'user_account_offline_text',
											'type'          => 'text',
											'title'         => __('Non-working Days Status Text','uwac'),
											'subtitle'		=> __('Shown on non-working days. The user account is offline.','uwac'),
											'desc'			=> __('Available tags: <code>%status%</code>, <code>%online_from%</code>, <code>%online_to%</code>'),
											'default'		=> __('Online from %online_from% to %online_to% GMT+4','uwac'),
										),
									),
								),
								array(
									'id'        	=> 'ua_schedule',
									'title'     	=> __('Schedule','uwac'),
									'description'	=> __('Set the user account schedule','uwac'),
									'fields'   	 	=> array(
										array(
											'id'            => 'user_account_always_available',
											'type'          => 'switcher',
											'title'         => __('Always Available','uwac'),
											'label'         => __('This account will be available all day 24/7','uwac'),
											'labels'        => array(
												'on'    => __('Yes','uwac'),
												'off'   => __('No','uwac'),
											),
											'default'		=> true,
										),
										array(
											'dependency'		=> array('user_account_always_available','==','false'),
											'id'				=> 'user_account_custom_schedule_fs',
											'type'				=> 'fieldset',
											'fields'			=> array(
												array(
													'id'              	=> 'user_account_custom_schedule',
													'type'            	=> 'group',
													'title'           	=> __('Availability Schedule','uwac'),
													// 'desc'            	=> 'Accordion title using the ID of the field.',
													'button_title'    		=> __('Add new day','uwac'),
													'accordion_title_new' 	=> __('New Day','uwac'),
													'accordion_title'		=> __('Day','uwac'),
													// 'accordion_title_field'	=> 'day_time_start',
													'accordion_title_format'=> array(
														'format'	=> __('%day_name% Available from %day_start% to %day_end%','uwac'),
														'fields'	=> array(
															'%day_name%'	=> 'day_name',
															'%day_start%'	=> 'day_time_start',
															'%day_end%'		=> 'day_time_end',
														),
													),
													'fields'          		=> array(
														array(
															'id'            => 'day_name',
															'type'          => 'select',
															'title'         => __('Day','uwac'),
															'options'		=> array(
																'monday'	=> __('Monday','uwac'),
																'tuesday'	=> __('Tuesday','uwac'),
																'wednesday'	=> __('Wednesday','uwac'),
																'thursday'	=> __('Thursday','uwac'),
																'friday'	=> __('Friday','uwac'),
																'saturday'	=> __('Saturday','uwac'),
																'sunday'	=> __('Sunday','uwac'),
															),
															'label_type'	=> 'top',
															'columns' 		=> '4',
														),
														array(
															'id'            => 'day_time_start',
															'type'          => 'select',
															'title'         => __('From','uwac'),
															'options'		=> array(
																"0:00" => "0:00",
																"0:30" => "0:30",
																"1:00" => "1:00",
																"1:30" => "1:30",
																"2:00" => "2:00",
																"2:30" => "2:30",
																"3:00" => "3:00",
																"3:30" => "3:30",
																"4:00" => "4:00",
																"4:30" => "4:30",
																"5:00" => "5:00",
																"5:30" => "5:30",
																"6:00" => "6:00",
																"6:30" => "6:30",
																"7:00" => "7:00",
																"7:30" => "7:30",
																"8:00" => "8:00",
																"8:30" => "8:30",
																"9:00" => "9:00",
																"9:30" => "9:30",
																"10:00" => "10:00",
																"10:30" => "10:30",
																"11:00" => "11:00",
																"11:30" => "11:30",
																"12:00" => "12:00",
																"12:30" => "12:30",
																"13:00" => "13:00",
																"13:30" => "13:30",
																"14:00" => "14:00",
																"14:30" => "14:30",
																"15:00" => "15:00",
																"15:30" => "15:30",
																"16:00" => "16:00",
																"16:30" => "16:30",
																"17:00" => "17:00",
																"17:30" => "17:30",
																"18:00" => "18:00",
																"18:30" => "18:30",
																"19:00" => "19:00",
																"19:30" => "19:30",
																"20:00" => "20:00",
																"20:30" => "20:30",
																"21:00" => "21:00",
																"21:30" => "21:30",
																"22:00" => "22:00",
																"22:30" => "22:30",
																"23:00" => "23:00",
																"23:30" => "23:30",
															),
															'default'		=> '8:00',
															'label_type'	=> 'top',
															'columns' 		=> '4',
														),
														array(
															'id'            => 'day_time_end',
															'type'          => 'select',
															'title'         => __('To','uwac'),
															'options'		=> array(
																"0:00" => "0:00",
																"0:30" => "0:30",
																"1:00" => "1:00",
																"1:30" => "1:30",
																"2:00" => "2:00",
																"2:30" => "2:30",
																"3:00" => "3:00",
																"3:30" => "3:30",
																"4:00" => "4:00",
																"4:30" => "4:30",
																"5:00" => "5:00",
																"5:30" => "5:30",
																"6:00" => "6:00",
																"6:30" => "6:30",
																"7:00" => "7:00",
																"7:30" => "7:30",
																"8:00" => "8:00",
																"8:30" => "8:30",
																"9:00" => "9:00",
																"9:30" => "9:30",
																"10:00" => "10:00",
																"10:30" => "10:30",
																"11:00" => "11:00",
																"11:30" => "11:30",
																"12:00" => "12:00",
																"12:30" => "12:30",
																"13:00" => "13:00",
																"13:30" => "13:30",
																"14:00" => "14:00",
																"14:30" => "14:30",
																"15:00" => "15:00",
																"15:30" => "15:30",
																"16:00" => "16:00",
																"16:30" => "16:30",
																"17:00" => "17:00",
																"17:30" => "17:30",
																"18:00" => "18:00",
																"18:30" => "18:30",
																"19:00" => "19:00",
																"19:30" => "19:30",
																"20:00" => "20:00",
																"20:30" => "20:30",
																"21:00" => "21:00",
																"21:30" => "21:30",
																"22:00" => "22:00",
																"22:30" => "22:30",
																"23:00" => "23:00",
																"23:30" => "23:30",
															),
															'default'		=> '17:30',
															'label_type'	=> 'top',
															'columns' 		=> '4',
														),
													),
												),
											),
										),
									),
								),
								array(
									'id'        	=> 'ua_visibility',
									'title'     	=> __('Visibility','uwac'),
									'description'	=> __('Set the user account visibility','uwac'),
									'fields'   	 	=> array(
										array(
											'id'        => 'user_account_woocommerce_visibility',
											'type'      => 'switcher',
											'title'     => __('Auto-show on WooCommerce Product Pages','uwac'),
											'label'     => __('Show this user account automatically in the WooCommerce product pages','uwac'),
											'labels'    => array(
												'on'    => __('Yes','uwac'),
												'off'   => __('No','uwac'),
											),
										),
										array(
											'dependency'	=> array('user_account_woocommerce_visibility','==','true'),
											'id'			=> 'user_account_woocommerce_position',
											'type'			=> 'select',
											'title'			=> __('Button Position','uwac'),
											'options'		=> array(
												'before_psd'		=> __('Before Product Short Description','uwac'),
												'after_psd'			=> __('After Product Short Description','uwac'),
												'before_atcf'		=> __('Before Add To Cart Form','uwac'),
												'before_atcb'		=> __('Before Add To Cart Button','uwac'),
												'after_atcb'		=> __('After Add To Cart Button','uwac'),
												'after_atcf'		=> __('After Add To Cart Form','uwac'),
												'before_pm'			=> __('Before Product Meta','uwac'),
												'after_pm'			=> __('After Product Meta','uwac'),
												'before_tabs'		=> __('Before Product Tabs','uwac'),
												'after_tabs'		=> __('After Product Tabs','uwac'),
												'before_related'	=> __('Before Related Products','uwac'),
												'after_related'		=> __('After Related Products','uwac'),
											),
											'default_option'	=> __('Choose a Position','uwac'),
										),
										array(
											'dependency'	=> array('user_account_woocommerce_visibility','==','true'),
											'id'         	=> 'user_account_visibility_content_type',
											'type'       	=> 'select',
											'title'      	=> __('Content Type','uwac'),
											'options'    	=> array(
												'all'			=> __('All WooCommerce Products','uwac'),
												'products'		=> __('WooCommerce Products','uwac'),
												'product_cat'	=> __('WooCommerce Product Categories','uwac'),
											),
											'default'    => 'all',
										),
										array(
											'dependency'	=> array('user_account_woocommerce_visibility|user_account_visibility_content_type','==|==','true|products'),
											'id'            => 'user_account_products',
											'type'          => 'checkbox',
											'title'         => __('WooCommerce Products','uwac'),
											'options'		=> 'products',
										),
										array(
											'dependency'	=> array('user_account_woocommerce_visibility|user_account_visibility_content_type','==|==','true|product_cat'),
											'id'            => 'user_account_product_cat',
											'type'          => 'checkbox',
											'title'         => __('WooCommerce Product Categories','uwac'),
											'options'		=> 'categories',
											'query_args' 	=> array(
												'taxonomy' 	=> 'product_cat',
												// 'orderby' 	=> 'name',
												// 'order'   	=> 'ASC'
											),
										),
										array(
											'id'        => 'user_account_visibility',
											'type'      => 'switcher',
											'title'     => __('Hide From Floating Widgets','uwac'),
											'label'     => __('Hide this user account in floating widgets','uwac'),
											'labels'    => array(
												'on'    => __('Yes','uwac'),
												'off'   => __('No','uwac'),
											),
										),
									),
								),
								array(
									'id'        	=> 'ua_theme',
									'title'     	=> __('Theme','uwac'),
									'description'	=> __('Set the user account button theme. Choose the one you like and start customizing it!','uwac'),
									'fields'    	=> array(
										array(
											'id'			=> 'button_theme',
											'type'			=> 'image_select',
											// 'title'			=> __('Theme','uwac'),
											'radio'			=> true,
											'options'		=> Uwac_Admin::get_themes('button'),
											'default'   	=> 'simple',
										),
										array(
											'id'			=> 'button_theme_settings',
											'type'			=> 'fieldset',
											'fields'		=> Uwac_Admin::get_themes_settings('button'),
										),
									),
								),
							),
						),

						array(
							'id'        => 'user_account_status',
							'type'      => 'switcher',
							'title'     => __('Disable User Account','uwac'),
							'label'     => __('Temporarily disable this user account instead of deleting it.','uwac'),
							'labels'    => array(
								'on'    => __('Yes','uwac'),
								'off'   => __('No','uwac'),
							),
						),
					),
				),
			),
		);
		

		/* ===============================================================================================
            FLOATING WIDGET
        =============================================================================================== */
		$options['floating_widget']	= array(
			'name'        => 'floating_widget',
			'title'       => __('Floating Widget','uwac'),
			'icon'        => 'cli cli-floating-menu-up',
			
			'fields'      => array(
				array(
					'type'    => 'heading',
					'content' => __('Floating Widget','uwac'),
				),
				array(
					'type'    => 'content',
					'content' => __('Floating widgets allow you to display a complete support team and let your customers choose which one to start a chat with. Every widget can be customized as you want, as well as the active user accounts and the pages where the widget will be visible.','uwac'),
				),

				array(
					'id'            => 'floatingwidget_idcounter',
					'type'          => 'text',
					'title'         => __('ID COUNTER','uwac'),
					'default'		=> '0',
					'attributes'	=> array(
						'readonly'	=> 'readonly',
						'hidden'	=> 'hidden',
					),
					'wrap_class'	=> 'hidden',
				),
				
				array(
					'id'              => 'floating_widgets',
					'type'            => 'group',
					// 'title'           => 'Group Field',
					// 'desc'            => 'Accordion title using the ID of the field.',
					'button_title'    		=> __('Add a new floating widget','uwac'),
					'accordion_title_new' 	=> __('New Floating Widget','uwac'),
					'accordion_title'		=> __('Floating Widget','uwac'),
					'accordion_title_field'	=> 'floatingwidget_name',
					'accordion_title_format'	=> array(
						'format'	=> __('%widget_name% de id: (%widget_id%)','uwac'),
						'fields'	=> array(
							'%widget_name%'	=> 'floatingwidget_name',
							'%widget_id%'	=> 'floatingwidget_id',
						),
					),
					'fields'          		=> array(
						array(
							'id'            => 'floatingwidget_name',
							'type'          => 'text',
							'title'         => __('Widget Name','uwac'),
							'subtitle'		=> __('Name this widget internally','uwac'),
							'label_type'	=> 'top',
							'columns' 		=> '6',
						),
						array(
							'id'            => 'floatingwidget_id',
							'type'          => 'text',
							'title'         => __('Widget ID','uwac'),
							'subtitle'		=> __('Wiget ID to use on shortcodes','uwac'),
							'label_type'	=> 'top',
							'columns' 		=> '6',
						),
						array(
							'id'				=> 'floatingwidget_sections',
							'type'				=> 'accordion',
							'accordion_title'	=> 'Accordion Title',
							'accordion_content'	=> array(
								array(
									'id'        => 'fw_visibility',
									'title'     	=> __('Visibility','uwac'),
									'description'	=> __('Set the widget visibility on different devices, front pages (posts, CPTs, pages, WooCommerce products) or admin dashboard pages','uwac'),
									'fields'   	 	=> array(
										array(
											'id'        => 'floating_widget_show_on_desktop',
											'type'      => 'switcher',
											'title'     => __('Desktop Visibility','uwac'),
											'label'     => __('Show this floating widget on desktop','uwac'),
											'labels'    => array(
												'on'    => __('Yes','uwac'),
												'off'   => __('No','uwac'),
											),
											'default'	=> true,
											'label_type'	=> 'top',
											'columns' 		=> '6',
										),
										array(
											'id'        => 'floating_widget_show_on_mobile',
											'type'      => 'switcher',
											'title'     => __('Mobile Visibility','uwac'),
											'label'     => __('Show this floating widget on mobile devices','uwac'),
											'labels'    => array(
												'on'    => __('Yes','uwac'),
												'off'   => __('No','uwac'),
											),
											'default'	=> true,
											'label_type'	=> 'top',
											'columns' 		=> '6',
										),
										array(
											'id'         	=> 'floating_widget_visibility_criteria',
											'type'       	=> 'button_set',
											'title'      	=> __('Visibility Criteria','uwac'),
											'subtitle'		=> __('Choose if you want to show or hide the widget in the selected content','uwac'),
											'options'    	=> array(
												'include'  	=> __('Show in or Include','uwac'),
												'exclude'  	=> __('Hide in or Exclude','uwac'),
											),
											'default'    	=> 'include',
										),
										array(
											'id'         	=> 'floating_widget_visibility_content_type',
											'type'       	=> 'select',
											'title'      	=> __('Content Type','uwac'),
											'options'    	=> array(
												__('Front Pages','uwac') => array(
													'home'			=> __('Home Page','uwac'),
													'all'			=> __('All Site','uwac'),
													'pages'  		=> __('Pages','uwac'),
													'posttypes'  	=> __('Post Types','uwac'),
													'posts'			=> __('Posts','uwac'),
													'post_cat'		=> __('Post Categories','uwac'),
													'products'		=> __('WooCommerce Products','uwac'),
													'product_cat'	=> __('WooCommerce Product Categories','uwac'),
												),
												__('Admin Dashboard Pages','uwac') => array(
													'admin_all'		=> __('All Admin Dashboard','uwac'),
													'admin_pages'	=> __('Admin Pages','uwac'),
												),
											),
											'default'    => 'include',
										),
										array(
											'dependency'	=> array('floating_widget_visibility_content_type','==','pages'),
											'id'            => 'floating_widget_pages',
											'type'          => 'checkbox',
											'title'         => __('Front Pages','uwac'),
											'options'		=> 'pages',
										),
										array(
											'dependency'	=> array('floating_widget_visibility_content_type','==','posttypes'),
											'id'            => 'floating_widget_posttypes',
											'type'          => 'checkbox',
											'title'         => __('Front Post Types','uwac'),
											'options'		=> 'post_types',
										),
										array(
											'dependency'	=> array('floating_widget_visibility_content_type','==','posts'),
											'id'            => 'floating_widget_posts',
											'type'          => 'checkbox',
											'title'         => __('Front Posts','uwac'),
											'options'		=> 'posts',
										),
										array(
											'dependency'	=> array('floating_widget_visibility_content_type','==','post_cat'),
											'id'            => 'floating_widget_post_cat',
											'type'          => 'checkbox',
											'title'         => __('Front Post Categories','uwac'),
											'options'		=> 'categories',
										),
										array(
											'dependency'	=> array('floating_widget_visibility_content_type','==','products'),
											'id'            => 'floating_widget_products',
											'type'          => 'checkbox',
											'title'         => __('Front WooCommerce Products','uwac'),
											'options'		=> 'products',
										),
										array(
											'dependency'	=> array('floating_widget_visibility_content_type','==','product_cat'),
											'id'            => 'floating_widget_product_cat',
											'type'          => 'checkbox',
											'title'         => __('Front WooCommerce Product Categories','uwac'),
											'options'		=> 'categories',
											'query_args' 	=> array(
												'taxonomy' 	=> 'product_cat',
												// 'orderby' 	=> 'name',
												// 'order'   	=> 'ASC'
											),
										),
										// Backend Pages
										array(
											// 'dependency'	=> array('floating_widget_visibility_mode','==','admin'),
											'dependency'	=> array('floating_widget_visibility_content_type','==','admin_pages'),
											'id'         	=> 'floating_widget_admin_pages',
											'type'          => 'checkbox',
											'title'         => __('Admin Pages','uwac'),
											'options'		=> 'admin_pages',
										),

									),
								),
								array(
									'id'        => 'fw_cta',
									'title'     	=> __('Call To Action','uwac'),
									'description'	=> __('Set the widget Call To Action effect and auto-open delay','uwac'),
									'fields'   	 	=> array(
										array(
											'id'        => 'floating_widget_autoopen_status',
											'type'      => 'switcher',
											'title'     => __('Auto Open','uwac'),
											'label'     => __('Open this floating widget automatically','uwac'),
											'labels'    => array(
												'on'    => __('Yes','uwac'),
												'off'   => __('No','uwac'),
											),
											'default'	=> false
										),
										array(
											'dependency'	=> array('floating_widget_autoopen_status','==','true'),
											'id'        => 'floating_widget_autoopen_type',
											'type'      => 'button_set',
											'title'     => __('Auto-open Trigger Type','uwac'),
											'options'    => array(
												'delay'  	=> __('Time Delay','uwac'),
												'scroll'  	=> __('Scroll Position','uwac'),
											),
											'default'    => 'delay',
										),
										array(
											'dependency'	=> array('floating_widget_autoopen_status|floating_widget_autoopen_type','==|==','true|delay'),
											'id'			=> 'floating_widget_autoopen_delay',
											'type'			=> 'slider',
											'title'			=> __('Auto-open Delay','uwac'),
											'desc'			=> __('Set the delay the widget will have to open automatically after the page loads completely.','uwac'),
											'settings'		=> array(
												'step'		=> 1,
												'min'		=> 1,
												'max'		=> 30,
												'unit'		=> __('sec','uwac'),
												'input'		=> true,
												'round'		=> true,
											),
											'default'	=> array(
												'slider1'	=> 6
											),
										),
										array(
											'dependency'	=> array('floating_widget_autoopen_status|floating_widget_autoopen_type','==|==','true|scroll'),
											'id'			=> 'floating_widget_autoopen_scroll',
											'type'			=> 'slider',
											'title'			=> __('Auto-open Scroll Position','uwac'),
											'desc'			=> __('Set the delay the widget will have to open automatically after the page loads completely.','uwac'),
											'settings'		=> array(
												'step'		=> 1,
												'min'		=> 1,
												'max'		=> 100,
												'unit'		=> __('%','uwac'),
												'input'		=> true,
												'round'		=> true,
											),
											'default'	=> array(
												'slider1'	=> 60
											),
										),
										array(
											'id'        => 'floating_widget_ctaeffect_status',
											'type'      => 'switcher',
											'title'     => __('Call To Action Animation','uwac'),
											'label'     => __('Use a call to action effect','uwac'),
											'labels'    => array(
												'on'    => __('Yes','uwac'),
												'off'   => __('No','uwac'),
											),
											'default'	=> false
										),
										array(
											'dependency'	=> array('floating_widget_ctaeffect_status','==','true'),
											'id'			=> 'floating_widget_ctaeffect',
											'type'			=> 'animate_css',
											'title'			=> __('Call To Action Animation Type','uwac'),
											'desc'			=> __('Set the animation that the button will use to call the action','uwac'),
											'default'		=> array(
												'effect'			=> 'shake',
												'iteration'			=> 'once',
												'iteration_delay'	=> 6000,
												'delay'				=> 0,
											),
											'settings'		=> array(
												'preview_text'	=> __('Call To Action Effect Preview Text','uwac'),
											),
										),
									),
								),
								array(
									'id'        	=> 'fw_button',
									'title'     	=> __('Widget Button','uwac'),
									'description'	=> __('Set the widget button text and icon','uwac'),
									'fields'    	=> array(
										array(
											'id'        => 'floatingwidget_button_label_status',
											'type'      => 'switcher',
											'title'     => __('Label Visibility','uwac'),
											'label'     => __('Force hide the floating button label','uwac'),
											'desc'		=> __('It can vary based on the theme that is chosen.','uwac'),
											'labels'    => array(
												'on'    => __('Yes','uwac'),
												'off'   => __('No','uwac'),
											),
										),
										array(
											'dependency'	=> array('floatingwidget_button_label_status','==','false'),
											'id'            => 'floatingwidget_button_label',
											'type'      	=> 'wysiwyg',
											'title'     	=> __('Label Text','uwac'),
											'subtitle'  	=> __('Enter the text that displays on the widget button','uwac'),
											'default'   	=> __('Need Help? <strong>Chat with us!</strong>','uwac'),
											'settings'  	=> array(
												'textarea_rows' => 5,
												'tinymce'       => true,
												'media_buttons' => false,
												'quicktags'     => false,
												'teeny'         => true,
											),
										),
										array(
											'id'            => 'floatingwidget_button_icon',
											'type'          => 'icon',
											'title'         => __('Icon','uwac'),
											'subtitle'      => __('Choose an icon for the button','uwac'),
											'default'       => 'cli cli-phone',
										),
									),
								),
								array(
									'id'        	=> 'fw_popup',
									'title'     	=> __('Widget Popup Window','uwac'),
									'description'	=> __('Set the widget popup window title, description and other predefined texts','uwac'),
									'fields'    	=> array(
										array(
											'id'            => 'floatingwidget_text_title',
											'type'          => 'text',
											'title'         => __('Title','uwac'),
											'subtitle'		=> __('Enter the text that displays on the title','uwac'),
											'default'		=> __('Start a Conversation','uwac'),
										),
										array(
											'id'            => 'floatingwidget_text_description',
											'type'      	=> 'wysiwyg',
											'title'     	=> __('Description','uwac'),
											'subtitle'  	=> __('Enter the text that displays below the title','uwac'),
											'default'   	=> __('Hi! Click one of our members below to chat on <strong>WhatsApp</strong>','uwac'),
											'settings'  	=> array(
												'textarea_rows' => 5,
												'tinymce'       => true,
												'media_buttons' => false,
												'quicktags'     => false,
												'teeny'         => true,
											),
										),
										array(
											'id'            => 'floatingwidget_text_response_time',
											'type'      	=> 'wysiwyg',
											'title'     	=> __('Response Time Text','uwac'),
											'subtitle'  	=> __('Enter the text that displays before the user accounts list','uwac'),
											'default'   	=> __('We usually reply in a <strong>few minutes</strong>','uwac'),
											'settings'  	=> array(
												'textarea_rows' => 5,
												'tinymce'       => true,
												'media_buttons' => false,
												'quicktags'     => false,
												'teeny'         => true,
											),
										),
									),
								),
								array(
									'id'        	=> 'fw_gdpr',
									'title'     	=> __('GDPR','uwac'),
									'description'	=> __('Set the widget GDPR notice status and text','uwac'),
									'fields'    	=> array(
										array(
											'id'        => 'floatingwidget_gdpr_status',
											'type'      => 'switcher',
											'title'     => __('GDPR','uwac'),
											'label'     => __('Show GDPR Notice','uwac'),
											'labels'    => array(
												'on'    => __('Yes','uwac'),
												'off'   => __('No','uwac'),
											),
											'default'	=> true
										),
										array(
											'dependency'	=> array('floatingwidget_gdpr_status','==','true'),
											'id'            => 'floatingwidget_gdpr_text',
											'type'      	=> 'wysiwyg',
											'title'     	=> __('GDPR Notice Text','uwac'),
											'subtitle'  	=> __('Enter the text that displays in the footer bar. HTML markup can be used.','uwac'),
											'default'   	=> __('Please accept our <a href="#">Privacy Policy</a> first to start a new conversation','uwac'),
											'settings'  	=> array(
												'textarea_rows' => 5,
												'tinymce'       => true,
												'media_buttons' => false,
												'quicktags'     => false,
												'teeny'         => true,
											),
										),
									),
								),
								array(
									'id'        	=> 'fw_accounts',
									'title'     	=> __('User Accounts','uwac'),
									'description'	=> __('Set the user accounts that will be displayed in this widget','uwac'),
									'fields'    	=> array(
										array(
											'id'        => 'floatingwidget_accounts_type',
											'type'      => 'button_set',
											'title'     => __('Show Accounts from','uwac'),
											'subtitle'	=> __('Choose the user accounts that will be active in this widget.','uwac'),
											'options'    => array(
												'all'  				=> __('All Users','uwac'),
												'online'  			=> __('Online Users','uwac'),
												'selected'			=> __('Selected Users','uwac'),
												'selected_online'	=> __('Selected Users Online','uwac'),
											),
											'default'    => 'all',
										),
										array(
											'dependency'	=> array('floatingwidget_accounts_type','any','selected,selected_online'),
											'id'        	=> 'floatingwidget_accounts_selected',
											'type'     		=> 'sorter',
											'title'     	=> __('Active User Accounts','uwac'),
											'subtitle'		=> __('If you make any changes to user accounts, please reload the list.','uwac'),
											'settings'		=> array(
												'enabled_title'		=> __('Active User Accounts','uwac'),
												'disabled_title'	=> __('Inactive User Accounts','uwac'),
											),
											'default'    	=> array(
												'enabled'  => array(
												),
												'disabled' => cs_uwac_get_all_users(),
											),
										),
										array(
											'dependency'	=> array('floatingwidget_accounts_type','any','selected,selected_online'),
											'id'        	=> 'floatingwidget_accounts_reload',
											'type'     		=> 'button',
											'value'     	=> __('<i class="cli cli-refresh-cw"></i> Reload User Accounts','uwac'),
										),
									),
								),
								array(
									'id'        	=> 'fw_theme',
									'title'     	=> __('Theme','uwac'),
									'description'	=> __('Set the widget theme. Choose the one you like and start customizing it!','uwac'),
									'fields'    	=> array(
										array(
											'id'			=> 'floatingwidget_theme',
											'type'			=> 'image_select',
											// 'title'			=> __('Theme','uwac'),
											'radio'			=> true,
											'options'		=> Uwac_Admin::get_themes('widget'),
											'default'   	=> 'simple',
										),
										array(
											'id'			=> 'floatingwidget_theme_settings',
											'type'			=> 'fieldset',
											'fields'		=> Uwac_Admin::get_themes_settings('widget'),
										),
									),
								),
							),
						),
						array(
							'id'        => 'floatingwidget_status',
							'type'      => 'switcher',
							'title'     => __('Disable Widget','uwac'),
							'label'     => __('Temporarily disable this floating widget instead of deleting it.','uwac'),
							'labels'    => array(
								'on'    => __('Yes','uwac'),
								'off'   => __('No','uwac'),
							),
						),
					),
				),
			),
		);
		
		
		/* ===============================================================================================
            CUSTOM CSS
        =============================================================================================== */
        $options['customcss'] = array(
            'name'        => 'customcss',
            'title'       => __('Custom CSS','uwac'),
            'icon'        => 'cli cli-code',
            
            // begin: fields
            'fields'      => array(
                array(
                    'type'    => 'heading',
                    'content' => __('Custom CSS','uwac'),
				),
				array(
                    'type'    => 'content',
                    'content' => __('Custom CSS code allows you to adjust Ultimate WhatsApp Chat to your specific needs.','uwac'),
                ),
                array(
                    'id'        => 'customcss_status',
                    'type'      => 'switcher',
                    'title'     => __('Custom CSS','uwac'),
                    'label'     => __('Enable the use of custom CSS code','uwac'),
                    'labels'    => array(
                        'on'    => __('Yes','uwac'),
                        'off'   => __('No','uwac'),
                    ),
                ),
                array(
                    'id'        => 'customcss',
                    'type'      => 'code_editor',
                    'title'     => __('Custom CSS','uwac'),
                    'subtitle'  => __('The code you paste here will be applied in all your chat widgets','uwac'),
                    'info'      => __('Information: If you need to overwrite any CSS setting, you can add !important at the end of CSS property. eg: margin: 10px !important;','uwac'),
                    'attributes'  => array(
                        'data-theme'    => 'monokai',  // the theme for ACE Editor
                        'data-mode'     => 'css',     // the language for ACE Editor
                    ),
				),
			),
		);


		/* ===============================================================================================
            BACKUP
        =============================================================================================== */
        $options[]   = array(
            'name'     => 'backup_section',
            'title'    => 'Backup',
            'icon'     => 'cli cli-shield',
            'fields'   => array(
				array(
                    'type'    => 'heading',
                    'content' => __('Backup Settings','uwac'),
				),
				array(
                    'type'    => 'content',
                    'content' => __('You can save your current options. Download a Backup and Import.','uwac'),
                ),
                array(
                    'type'    => 'backup',
                ),
            ),
		);
		
		return $options;
		
	}
}


function cs_uwac_get_all_users(){
	$user_accounts = cs_uwac_get_settings('user_accounts','cs-uwac');
	$output = array();

	if (!empty($user_accounts)){
		foreach ($user_accounts as $account){
			$user_name 			= $account['user_account_name'];
			$user_id 			= $account['user_account_id'];
			$hidden_on_widgets 	= (isset($account['useraccount_sections']['ua_visibility']['user_account_visibility'])) ? $account['useraccount_sections']['ua_visibility']['user_account_visibility'] : false;
	
			if (!$hidden_on_widgets){
				$output[$user_id] = $user_name;
			}
		}
	}
	return $output;
}

/**
 * Unique Options Page
 */
$settings = array(
	'menu_type'             => 'menu', // menu, submenu, options, theme, etc.
	'menu_parent'           => '',
	'menu_title'            => __('Ultimate WhatsApp Chat','uwac'),
	'menu_slug'             => 'cs-uwac',
	'menu_capability'       => 'manage_options',
	'menu_icon'             => 'dashicons-cli-whatsapp',
	'menu_position'         => null,
	'show_submenus'         => true,
	'framework_title'       => __('Ultimate WhatsApp Chat','uwac'),
	'framework_subtitle'    => __(UWAC_VERSION,'uwac'),
	'ajax_save'             => true,
	'buttons'               => array('reset' => false),
	'option_name'           => 'cs-uwac',
	'override_location'     => '',
	'extra_css'             => array(),
	'extra_js'              => array(),
	'is_single_page'        => true,
	'is_sticky_header'      => false,
	'style'                 => 'modern',
	'help_tabs'             => array(),
	'show_all_options_link'	=> false,
);
$module_settings    = new CSSFramework( $settings );
$module_options     = new CS_WHATSAPP_CHAT_SETTINGS();
$fn = function() use($module_settings,$module_options){
	$options = $module_options->set_options();
	$module_settings->set_options($options);
};
add_action( 'admin_menu', $fn );